import ui
import uiScriptLocale
import net
import time
import item
import snd
import localeInfo
import app
import player
import chat
import mouseModule
import constInfo
import grp
import dbg
import uiToolTip
import uiCommon
import uiWhisper
import wndMgr


##Should be disabled becouse this is only for my client UI ##
POSITION_FIX=False
#############################################################

class GiftDialog(ui.BoardWithTitleBar):

	CULOARE_DESCRIERE_EVENT =  0xfffeba68

	def __init__(self):
		ui.BoardWithTitleBar.__init__(self)
		self.UI = {}
		self.pop=None
		self.pages = []
		self.pageCur = 1
		self.pageNum = 0
		self.search=""
		self.tooltipItem = uiToolTip.ItemToolTip()
		self.tooltipItem.Hide()	
		self.LoadWindow()

	def __del__(self):
		ui.BoardWithTitleBar.__del__(self)

	def LoadWindow(self):
		self.SetSize(500, 320)		
		self.SetTitleName("Depozit Magazin Privat")
		self.SetCloseEvent(ui.__mem_func__(self.Close))
		self.AddFlag("movable")
		self.Hide()
		
		slots = ui.GridSlotWindow()
		slots.SetParent(self)
		slots.SetPosition(10,30)
		slots.SetSize(480, 280)
		slots.ArrangeSlot(0, 15,8, 32, 32, 0, 0)
		slots.RefreshSlot()
		slots.SetSlotBaseImage("d:/ymir work/ui/public/Slot_Base.sub", 1.0, 1.0, 1.0, 1.0)
		slots.SAFE_SetButtonEvent("LEFT", "EXIST", self.OnSelectItemSlot)
		slots.SAFE_SetButtonEvent("RIGHT", "EXIST", self.UnselectItemSlot)
		slots.SetOverInItemEvent(ui.__mem_func__(self.OverInItem))
		slots.SetOverOutItemEvent(ui.__mem_func__(self.OverOutItem))
		slots.Show()
		self.slots = slots
		
		
		Y=self.GetHeight()-30
		if POSITION_FIX:
			Y=self.GetHeight()-43
			
		get_button = ui.MakeButton(self,250, Y,"","d:/ymir work/ui/public/","large_Button_01.sub","large_Button_02.sub","large_Button_03.sub")
		get_button.SetText(uiScriptLocale.GIFT_GET_ALL)
		get_button.SetEvent(lambda : self.GetAll())
		get_button.Show()
		self.get_button = get_button
		
		self.pageSlotImage = ui.MakeImageBox(self, "d:/ymir work/ui/public/Parameter_Slot_00.sub", self.GetWidth()-110, Y)
		
		pageSlot = ui.MakeTextLine(self.pageSlotImage)
		pageSlot.SetWindowHorizontalAlignCenter()
		pageSlot.SetHorizontalAlignCenter()
		pageSlot.SetText(str(self.pageCur)+" - "+str(self.pageNum+1))
		pageSlot.Show()
		self.pageSlot = pageSlot
		
		
		## Prev Button
		prevButton = ui.MakeButton(self, self.GetWidth()-160, Y ,uiScriptLocale.GIFT_PREV_PAGE, "d:/ymir work/ui/public/", "small_button_01.sub", "small_button_02.sub", "small_button_03.sub")
		prevButton.SetText("<<")
		prevButton.SetEvent(ui.__mem_func__(self.PrepPage), -1)
		self.prevButton = prevButton
		
		## Next Button
		nextButton = ui.MakeButton(self, self.GetWidth()-65, Y , uiScriptLocale.GIFT_NEXT_PAGE, "d:/ymir work/ui/public/", "small_button_01.sub", "small_button_02.sub", "small_button_03.sub")
		nextButton.SetText(">>")
		nextButton.SetEvent(ui.__mem_func__(self.PrepPage), 1)
		self.nextButton = nextButton
		
		##buton info
		infoButton = ui.Button()
		infoButton.SetParent(self)
		infoButton.SetPosition(228, 291)
		infoButton.SetUpVisual("d:/ymir work/ui/pattern/q_mark_01.tga")
		infoButton.SetOverVisual("d:/ymir work/ui/pattern/q_mark_02.tga")
		infoButton.SetDownVisual("d:/ymir work/ui/pattern/q_mark_01.tga")
		infoButton.SetToolTipWindow(self._CreateToolTip("Atentie", "Asigura-te ca suma din inventar nu depaseste 2kkk dupa retragerea banilor!"))
		infoButton.Show()
		self.infoButton = infoButton
		##buton info
		
		self.AddFlag("movable")
		self.AddFlag("float")
		self.SetCenterPosition()
		self.Show()
		
	##buton info
	def _CreateToolTip(self, title, descList):
		toolTip = uiToolTip.ToolTip()
		toolTip.SetTitle(title)
		toolTip.AppendDescription(descList, None, self.CULOARE_DESCRIERE_EVENT)
		toolTip.SetFollow(True)

		toolTip.AlignHorizonalCenter()
		return toolTip
	##buton info

	def Open(self):
		self.SetCenterPosition()
		self.Show()	
		self.Show()
		self.SetCenterPosition()
		self.LoadPage(self.pageCur)
		net.SendChatPacket("/gift_refresh")

	def LoadPage(self,page):
		self.pageCur=page
		net.SendChatPacket("/gift_refresh "+str(page))

	def PrepPage(self,page):
		if page==1 and self.pageCur==self.pageNum or self.pageCur == 1 and page<1:
			return
		page=self.pageCur+page
		self.LoadPage(page)

	def OnUpdate(self):
		self.pageSlot.SetText(str(self.pageCur)+" - "+str(self.pageNum))
		
	def Close(self):
		if None != self.tooltipItem:
			self.tooltipItem.HideToolTip()
		self.Hide()
		return TRUE
		
	def OnPressEscapeKey(self):
		if None != self.tooltipItem:
			self.tooltipItem.HideToolTip()
		self.Hide()
		return TRUE

	def Clear(self):
		constInfo.gift_items={}
		self.Refresh()

	def GetItemCount(self,slot):
		try:
			return int(constInfo.gift_items[int(slot)]["count"])
		except KeyError:
			return 0
		
	def GetItemID(self,slot):
		try:
			return int(constInfo.gift_items[int(slot)]["vnum"])
		except KeyError:
			return 0
	
	def Refresh(self):
		for i in xrange(self.slots.GetSlotCount()):
			vnum=self.GetItemID(i)
			itemCount = self.GetItemCount(i)
			if vnum == 1 or itemCount==0:
				itemCount=0
			self.slots.SetItemSlot(i, vnum, itemCount)
		wndMgr.RefreshSlot(self.slots.GetWindowHandle())
		self.slots.RefreshSlot()

	def __ShowToolTip(self, slot):
		if self.tooltipItem:
			self.tooltipItem.ClearToolTip()
			self.tooltipItem.SetCannotUseItemForceSetDisableColor(0)
			if int(slot) in constInfo.gift_items.keys():
				it=constInfo.gift_items[int(slot)]
				#self.tooltipItem.AppendTextLine("|cff18BB00|h[Item ID: %d]|h|r" % (it["id"]))
				#self.tooltipItem.AppendSpace(5)
				if it["vnum"]==1:
					self.tooltipItem.ClearToolTip()
					self.tooltipItem.SetTitle(localeInfo.NumberToMoneyString(it["count"]))
					self.tooltipItem.AppendDescription(uiScriptLocale.GIFT_MONEY_DESC, 26)
					self.tooltipItem.AppendDescription(item.GetItemSummary(), 26, 0xffBEB47D)
					self.tooltipItem.ShowToolTip()
				else:
					self.tooltipItem.AddItemData(int(it["vnum"]),it["sockets"],it["attrs"])
				self.tooltipItem.AppendTextLine("|cff18BB00|h[%s %s]|h|r" % (uiScriptLocale.GIFT_FROM,it["give"]))
				self.tooltipItem.AppendSpace(5)
				self.tooltipItem.AppendTextLine("|cff18BB00|h[%s %s]|h|r" % (uiScriptLocale.GIFT_REASON,it["reason"]))
				self.tooltipItem.AppendSpace(5)
			else:
				self.tooltipItem.ClearToolTip()
				self.tooltipItem.HideToolTip()
			
	def OverInItem(self, slotIndex):
		#slotIndex = self.__GetRealIndex(slotIndex)
		self.slots.SetUsableItem(FALSE)
		self.__ShowToolTip(slotIndex)

	def OverOutItem(self):
		self.slots.SetUsableItem(FALSE)
		if self.tooltipItem:
			self.tooltipItem.ClearToolTip()
			self.tooltipItem.HideToolTip()

	def UnselectItemSlot(self,selectedSlotPos):
		self.__OnClosePopupDialog()

	def OnSelectItemSlot(self, selectedSlotPos):
		isAttached = mouseModule.mouseController.isAttached()
		if isAttached:
			snd.PlaySound("sound/ui/loginfail.wav")
			mouseModule.mouseController.DeattachObject()
			self.Hide()
		else:
			if not int(selectedSlotPos) in constInfo.gift_items.keys():
				self.Hide()
				return

			snd.PlaySound("sound/ui/drop.wav")
			self.Get(selectedSlotPos)

	def __OnClosePopupDialog(self):
		if self.pop != None:
			if self.pop.IsShow():
				self.pop.Hide()
		self.pop = None

	def PopupMessage(self,text):
		pop = uiCommon.PopupDialog()
		pop.SetText(text)
		pop.SetAcceptEvent(self.__OnClosePopupDialog)
		pop.Open()
		self.pop = pop
		self.pop.SetTop()

	def Get(self,slot):
		if int(slot) in constInfo.gift_items.keys():
			it=constInfo.gift_items[int(slot)]
			item.SelectItem(int(it["vnum"]))
			self.pop = uiCommon.QuestionDialog()
			self.pop.SetText(uiScriptLocale.GIFT_GET_QUEST%(item.GetItemName()))
			self.pop.SetAcceptEvent(lambda arg1=str(it["id"]): self.OnGet(arg1))
			self.pop.SetCancelEvent(ui.__mem_func__(self.__OnClosePopupDialog))
			self.pop.Open()
		
	def GetAll(self):
		self.pop = uiCommon.QuestionDialog()
		self.pop.SetText(uiScriptLocale.GIFT_GET_QUEST_ALL)
		self.pop.SetAcceptEvent(lambda arg1="": self.OnGet(arg1))
		self.pop.SetCancelEvent(ui.__mem_func__(self.__OnClosePopupDialog))
		self.pop.Open()
			
	def OnGet(self,id):
		net.SendChatPacket("/gift_get "+str(id))	
		self.__OnClosePopupDialog()
		if len(constInfo.gift_items.keys())-1<=0:
			self.Close()
		
class Edit2(ui.EditLine):
	def __init__(self,parent,text,x,y,width,height,number=FALSE,slot=2,max = 12):
		ui.EditLine.__init__(self)
		self.imageSlot=ui.MakeImageBox(parent, "d:/ymir work/ui/public/Parameter_Slot_0"+str(slot)+".sub", x,y)
		self.SetText(text)
		self.main = text
		self.SetMax(max)
		self.SetUserMax(max)
		self.SetParent(self.imageSlot)
		if number:
			self.SetNumberMode()
		self.SetSize(width,height)
		self.SetPosition(5,2)
		self.Show()

	def GetText(self):
		res = ui.EditLine.GetText(self)
		if res == "":
			return ""
		else:
			return res
			
	def __del__(self):
		ui.EditLine.__del__(self)

	def OnSetFocus(self):
		ui.EditLine.OnSetFocus(self)
		if ui.EditLine.GetText(self) == self.main:
			self.SetText("")

	def OnKillFocus(self):
		ui.EditLine.OnKillFocus(self)
		if ui.EditLine.GetText(self) == "":
			self.SetText(self.main)