import ui
import dbg
import app
import wndMgr
import chat
import constInfo
import snd
import net

class DailyWindow(ui.Window):
	def __init__(self):
		ui.Window.__init__(self)
		self.dni = {}
		self.BuildWindow()

	def __del__(self):
		ui.Window.__del__(self)
		
	def Destroy(self):
		self.dni = {}

	def BuildWindow(self):
		self.Board = ui.BoardWithTitleBar()
		self.Board.SetSize(760, 210)
		self.Board.SetCenterPosition()
		self.Board.AddFlag('movable')
		self.Board.AddFlag('float')
		self.Board.SetTitleName('System Nagrd Dziennych - Dzie 1')
		self.Board.SetCloseEvent(self.Close)
		
		for i in xrange(7):
			DayWindow = ui.ThinBoard()
			DayWindow.SetParent(self.Board)
			DayWindow.SetSize(100, 150)
			DayWindow.SetPosition(15+105*i, 40)
			DayWindow.Show()
			
			DayName = ui.TextLine()
			DayName.SetParent(DayWindow)
			DayName.SetWindowHorizontalAlignCenter()
			DayName.SetHorizontalAlignCenter()
			DayName.SetText("Dzie "+str(i+1))
			DayName.SetFontColor(1, 0.843, 0) ##zoty
			DayName.Show()
			
			DayItem = ui.ExpandedImageBox()
			DayItem.SetParent(DayWindow)
			DayItem.SetPosition(34, 55)
			DayItem.LoadImage("d:/ymir work/ui/present.tga")
			DayItem.Show()
			
			DayButton = ui.Button()
			DayButton.SetParent(DayWindow)
			DayButton.SetPosition(30, 120)
			DayButton.SetUpVisual("d:/ymir work/ui/public/small_button_01.sub")
			DayButton.SetOverVisual("d:/ymir work/ui/public/small_button_02.sub")
			DayButton.SetDownVisual("d:/ymir work/ui/public/small_button_03.sub")
			DayButton.SetEvent(ui.__mem_func__(self.GetDaily))
			DayButton.SetText("Odbierz")
			DayButton.Show()
			
			DayStatus = ui.TextLine()
			DayStatus.SetParent(DayWindow)
			DayStatus.SetPosition(30, 120)
			DayStatus.Show()
			
			self.dni[i] = [DayWindow, DayName, DayItem, DayButton, DayStatus]
		
	def FormatTime(self, time):
		m, s = divmod(time, 60)
		h, m = divmod(m, 60)
		return "%02d:%02d:%02d" % (h, m, s)
		
	def DailyUpdate(self):
		day = constInfo.DAILY_DAY
		time = constInfo.DAILY_TIME - app.GetGlobalTimeStamp()
		self.Board.SetTitleName('System Nagrd Dziennych - Dzie '+str(day))
		
		for i in xrange(7):
			(DayWindow, DayName, DayItem, DayButton, DayStatus) = self.dni[i]
			q = day-1
			if i == q:
				if time > 0:
					DayButton.Hide()
					DayStatus.SetText(str(self.FormatTime(time)))
					DayStatus.SetFontColor(0.0, 1.0, 0.0)
					DayStatus.Show()
				else:
					DayButton.Show()
					DayStatus.Hide()
			else:
				DayButton.Hide()
				DayStatus.Hide()
				if i < q:
					DayStatus.SetText("odebrany")
					DayStatus.SetFontColor(1.0, 0.0, 0.0)
					DayStatus.Show()
					
	def GetDaily(self):
		net.SendChatPacket("/get_daily")
	
	def Close(self):
		self.Board.Hide()
	
	def Show(self):
		if self.Board.IsShow():
			self.Board.Hide()
		else:
			self.Board.Show()
		
	def OnPressEscapeKey(self):
		if self.Board.IsShow():
			self.Close()
			return TRUE
		return FALSE
