from ui_wrapper import _ui
import dbg, player, item, event, systemSetting
import ui, mouseModule, uiToolTip, constInfo

class BKTrade(ui.Window):
	def __init__(self):
		ui.Window.__init__(self)

		self.ItemList = [] #vnum list
		self.ItemDict = {} #slot wrapper
		self.Grids = {}    #gui grid elements

		self.tooltipItem = uiToolTip.ItemToolTip()
		self.tooltipItem.Hide()

		self.GUIFunc()

	def __del__(self):
		ui.Window.__del__(self)

	def GUIFunc(self):
		self.Board = _ui().BoardWithTitleBar(None, 1, systemSetting.GetWidth() /2 -200, 50, 230, 170, "Schimb Carti", self.OpenWindow) # parent moveable x y width heigh title event
		self.Price = _ui().TextLine(self.Board, "Cost: 10.000.000 Yang", 65, 115)
		self.Accept = _ui().Button(self.Board, "OK", "", 45, 135, self.SendToServer, 'd:/ymir work/ui/public/middle_button_01.sub', 'd:/ymir work/ui/public/middle_button_02.sub', 'd:/ymir work/ui/public/middle_button_03.sub')
		self.Cancel = _ui().Button(self.Board, "Anuleaza", "", 125, 135, self.OpenWindow, 'd:/ymir work/ui/public/middle_button_01.sub', 'd:/ymir work/ui/public/middle_button_02.sub', 'd:/ymir work/ui/public/middle_button_03.sub')
		#self.ClearGrids = _ui().Button(self.Board, "", "Reload", 200, 32, self.RemoveAllItems, "d:/ymir work/ui/game/guild/refresh_button_01.sub", "d:/ymir work/ui/game/guild/refresh_button_02.sub", "d:/ymir work/ui/game/guild/refresh_button_03.sub")

		pos_list = [
			[32,40],[32*2,40],[32*3,40],[32*4,40],[32*5,40],
			[32,72],[32*2,72],[32*3,72],[32*4,72],[32*5,72]
		]
		for i in xrange(len(pos_list)):
			self.Grids["Tab"+str(i)] = _ui().GridSlotWindow(self.Board, pos_list[i][0], pos_list[i][1], self.SelectItemSlot, self.RemoveItem, self.OverInItem, self.OnOverOutItem, i, 1, 1, 32, 32, 0, 0)

	def SendToServer(self):
		if not len(self.ItemList) == 10: #Check Grid count
			self.Notification = _ui().Popup("Nu sunt destule carti", None, None)
			return

		tmpInventoryPosList = [] # Create Temporary Inventory pos list
		for i in self.ItemList:
			tmpInventoryPosList.append(self.ItemDict[i])

		asStringPosList = '|'.join(str(i) for i in tmpInventoryPosList) # Convert Inventory pos list to string

		constInfo.BK_TRADE_SYSTEM["ItemList"] = asStringPosList
		event.QuestButtonClick(int(constInfo.BK_TRADE_SYSTEM["qid"]))
		self.RemoveAllItems()

	#@Unofficial func
	def RemoveAllItems(self):
		# All items from list
		del self.ItemList[:]
		self.ItemDict.clear() # All items from dict
		for i in xrange(5*2):
			self.Grids["Tab"+str(i)].SetItemSlot(i, 0, 0) # Set all grid items as 0
			self.Grids["Tab"+str(i)].RefreshSlot() # Reload grids

	#@Tooltip select item event
	def OverInItem(self, itemSlotIndex):
		#itemSlotIndex -> Grid slot - self.ItemDict[itemSlotIndex] -> Inventory slot - itemIndex -> Vnum
		itemIndex = player.GetItemIndex(self.ItemDict[itemSlotIndex])
		item.SelectItem(itemIndex)

		metinSlot = [player.GetItemMetinSocket(self.ItemDict[itemSlotIndex], i) for i in xrange(player.METIN_SOCKET_MAX_NUM)] # Socket list
		attrSlot = [player.GetItemAttribute(self.ItemDict[itemSlotIndex], i) for i in xrange(player.ATTRIBUTE_SLOT_MAX_NUM)]  # Attr list

		self.tooltipItem.ClearToolTip()
		self.tooltipItem.AddRefineItemData(itemIndex, metinSlot, attrSlot)
		self.tooltipItem.Show()

	#@Tooltip unselect item event
	def OnOverOutItem(self):
		self.tooltipItem.ClearToolTip()
		self.tooltipItem.Hide()

	#@Remove Item event from grids
	def RemoveItem(self, idx):
		self.ItemList.remove(idx)
		del self.ItemDict[idx]
		self.Grids["Tab"+str(idx)].SetItemSlot(idx, 0, 0)
		self.Grids["Tab"+str(idx)].RefreshSlot()

	#@Append Item event to grids
	def SelectItemSlot(self, itemSlotIndex):
		isAttached = mouseModule.mouseController.isAttached()
		if isAttached:
			attachedSlotPos = mouseModule.mouseController.GetAttachedSlotNumber()
			if player.IsEquipmentSlot(attachedSlotPos):
				self.Notification = _ui().Popup("Nu poti face asta", None, None)
				mouseModule.mouseController.DeattachObject()
				return
			if attachedSlotPos in self.ItemDict.values():
				self.Notification = _ui().Popup("Nu poti adauga aceeasi carte", None, None)
				mouseModule.mouseController.DeattachObject()
				return
			itemIndex = player.GetItemIndex(attachedSlotPos)
			if not itemIndex == 50300:
				self.Notification = _ui().Popup("Poti adauga doar carti", None, None)
				mouseModule.mouseController.DeattachObject()
				return
			itemCount = player.GetItemCount(attachedSlotPos)
			if itemCount > 1:
				self.Notification = _ui().Popup("Adauga cate o carte pe rand", None, None)
				mouseModule.mouseController.DeattachObject()
				return
			item.SelectItem(itemIndex)

			if itemCount == 1:
				self.Grids["Tab"+str(itemSlotIndex)].SetItemSlot(itemSlotIndex, itemIndex, 0)
			else:
				self.Grids["Tab"+str(itemSlotIndex)].SetItemSlot(itemSlotIndex, itemIndex, itemCount)

			self.ItemDict[itemSlotIndex] = attachedSlotPos
			self.ItemList.append(itemSlotIndex)

			mouseModule.mouseController.DeattachObject()

	def OpenWindow(self):
		if self.Board.IsShow():
			self.Board.Hide()
		else:
			self.Board.Show()

	def Close(self):
		self.Board.Hide()

#BKTrade()
